/******************************************************
 * ArchC formatted registers header file.             *
 * This file is automatically generated by ArchC      *
 * WITHOUT WARRANTY OF ANY KIND, either express       *
 * or implied.                                        *
 * For more information on ArchC, please visit:       *
 * http://www.archc.org                               *
 *                                                    *
 * The ArchC Team                                     *
 * Computer Systems Laboratory (LSC)                  *
 * IC-UNICAMP                                         *
 * http://www.lsc.ic.unicamp.br                       *
 ******************************************************/

#ifndef _NIOS32_FMT_REGS_H_
#define _NIOS32_FMT_REGS_H_

#include "ac_sync_reg.H"
#include <string>

#include "nios32_parms.H"
//! ArchC classes for formatted registers.

class nios32_fmt_F_IF_ID
{
  char* name;

 public:
  ac_sync_reg<unsigned long> npc;
  ac_sync_reg<unsigned long> opcode;

  nios32_fmt_F_IF_ID(char* n): name(n), npc(std::string(std::string(n) + std::string("_npc")).c_str(), 0), opcode(std::string(std::string(n) + std::string("_opcode")).c_str(), 0)
  {
   return;
  }

  void change_dump(ostream& output)
  {
   return;
  }

  void reset_log()
  {
   return;
  }

  void suspend()
  {
   npc.suspend();
   opcode.suspend();
   return;
  }

  void behavior(nios32_parms::ac_stage_list stage = static_cast<nios32_parms::ac_stage_list>(0), int cycle = 0);
};

class nios32_fmt_F_ID_EX
{
  char* name;

 public:
  ac_sync_reg<unsigned long> npc;
  ac_sync_reg<unsigned long> data1;
  ac_sync_reg<unsigned long> data2;
  ac_sync_reg<unsigned long> imm;
  ac_sync_reg<unsigned long> ra;
  ac_sync_reg<unsigned long> rb;
  ac_sync_reg<unsigned long> regwrite;
  ac_sync_reg<unsigned long> memread;
  ac_sync_reg<unsigned long> memwrite;

  nios32_fmt_F_ID_EX(char* n): name(n), npc(std::string(std::string(n) + std::string("_npc")).c_str(), 0), data1(std::string(std::string(n) + std::string("_data1")).c_str(), 0), data2(std::string(std::string(n) + std::string("_data2")).c_str(), 0), imm(std::string(std::string(n) + std::string("_imm")).c_str(), 0), ra(std::string(std::string(n) + std::string("_ra")).c_str(), 0), rb(std::string(std::string(n) + std::string("_rb")).c_str(), 0), regwrite(std::string(std::string(n) + std::string("_regwrite")).c_str(), 0), memread(std::string(std::string(n) + std::string("_memread")).c_str(), 0), memwrite(std::string(std::string(n) + std::string("_memwrite")).c_str(), 0)
  {
   return;
  }

  void change_dump(ostream& output)
  {
   return;
  }

  void reset_log()
  {
   return;
  }

  void suspend()
  {
   npc.suspend();
   data1.suspend();
   data2.suspend();
   imm.suspend();
   ra.suspend();
   rb.suspend();
   regwrite.suspend();
   memread.suspend();
   memwrite.suspend();
   return;
  }

  void behavior(nios32_parms::ac_stage_list stage = static_cast<nios32_parms::ac_stage_list>(0), int cycle = 0);
};

class nios32_fmt_F_EX_MEM
{
  char* name;

 public:
  ac_sync_reg<unsigned long> imm;
  ac_sync_reg<unsigned long> wdata;
  ac_sync_reg<unsigned long> rdest;
  ac_sync_reg<unsigned long> regwrite;
  ac_sync_reg<unsigned long> memread;
  ac_sync_reg<unsigned long> memwrite;

  nios32_fmt_F_EX_MEM(char* n): name(n), imm(std::string(std::string(n) + std::string("_imm")).c_str(), 0), wdata(std::string(std::string(n) + std::string("_wdata")).c_str(), 0), rdest(std::string(std::string(n) + std::string("_rdest")).c_str(), 0), regwrite(std::string(std::string(n) + std::string("_regwrite")).c_str(), 0), memread(std::string(std::string(n) + std::string("_memread")).c_str(), 0), memwrite(std::string(std::string(n) + std::string("_memwrite")).c_str(), 0)
  {
   return;
  }

  void change_dump(ostream& output)
  {
   return;
  }

  void reset_log()
  {
   return;
  }

  void suspend()
  {
   imm.suspend();
   wdata.suspend();
   rdest.suspend();
   regwrite.suspend();
   memread.suspend();
   memwrite.suspend();
   return;
  }

  void behavior(nios32_parms::ac_stage_list stage = static_cast<nios32_parms::ac_stage_list>(0), int cycle = 0);
};

class nios32_fmt_F_MEM_WB
{
  char* name;

 public:
  ac_sync_reg<unsigned long> rdest;
  ac_sync_reg<unsigned long> wdata;
  ac_sync_reg<unsigned long> regwrite;

  nios32_fmt_F_MEM_WB(char* n): name(n), rdest(std::string(std::string(n) + std::string("_rdest")).c_str(), 0), wdata(std::string(std::string(n) + std::string("_wdata")).c_str(), 0), regwrite(std::string(std::string(n) + std::string("_regwrite")).c_str(), 0)
  {
   return;
  }

  void change_dump(ostream& output)
  {
   return;
  }

  void reset_log()
  {
   return;
  }

  void suspend()
  {
   rdest.suspend();
   wdata.suspend();
   regwrite.suspend();
   return;
  }

  void behavior(nios32_parms::ac_stage_list stage = static_cast<nios32_parms::ac_stage_list>(0), int cycle = 0);
};

class nios32_fmt_F_STATUS
{
  char* name;

 public:
  ac_sync_reg<unsigned long> dc;
  ac_sync_reg<unsigned long> ic;
  ac_sync_reg<unsigned long> ie;
  ac_sync_reg<unsigned long> ipri;
  ac_sync_reg<unsigned long> cwp;
  ac_sync_reg<unsigned long> n;
  ac_sync_reg<unsigned long> v;
  ac_sync_reg<unsigned long> z;
  ac_sync_reg<unsigned long> c;

  nios32_fmt_F_STATUS(char* n): name(n), dc(std::string(std::string(n) + std::string("_dc")).c_str(), 0), ic(std::string(std::string(n) + std::string("_ic")).c_str(), 0), ie(std::string(std::string(n) + std::string("_ie")).c_str(), 0), ipri(std::string(std::string(n) + std::string("_ipri")).c_str(), 0), cwp(std::string(std::string(n) + std::string("_cwp")).c_str(), 0), n(std::string(std::string(n) + std::string("_n")).c_str(), 0), v(std::string(std::string(n) + std::string("_v")).c_str(), 0), z(std::string(std::string(n) + std::string("_z")).c_str(), 0), c(std::string(std::string(n) + std::string("_c")).c_str(), 0)
  {
   return;
  }

  void change_dump(ostream& output)
  {
   return;
  }

  void reset_log()
  {
   return;
  }

  void suspend()
  {
   dc.suspend();
   ic.suspend();
   ie.suspend();
   ipri.suspend();
   cwp.suspend();
   n.suspend();
   v.suspend();
   z.suspend();
   c.suspend();
   return;
  }

  void behavior(nios32_parms::ac_stage_list stage = static_cast<nios32_parms::ac_stage_list>(0), int cycle = 0);
};

class nios32_fmt_F_WVALID
{
  char* name;

 public:
  ac_sync_reg<unsigned long> nu;
  ac_sync_reg<unsigned long> hi_limit;
  ac_sync_reg<unsigned long> lo_limit;

  nios32_fmt_F_WVALID(char* n): name(n), nu(std::string(std::string(n) + std::string("_nu")).c_str(), 0), hi_limit(std::string(std::string(n) + std::string("_hi_limit")).c_str(), 0), lo_limit(std::string(std::string(n) + std::string("_lo_limit")).c_str(), 0)
  {
   return;
  }

  void change_dump(ostream& output)
  {
   return;
  }

  void reset_log()
  {
   return;
  }

  void suspend()
  {
   nu.suspend();
   hi_limit.suspend();
   lo_limit.suspend();
   return;
  }

  void behavior(nios32_parms::ac_stage_list stage = static_cast<nios32_parms::ac_stage_list>(0), int cycle = 0);
};

class nios32_fmt_F_ISTATUS
{
  char* name;

 public:
  ac_sync_reg<unsigned long> nu;
  ac_sync_reg<unsigned long> savedstatus;

  nios32_fmt_F_ISTATUS(char* n): name(n), nu(std::string(std::string(n) + std::string("_nu")).c_str(), 0), savedstatus(std::string(std::string(n) + std::string("_savedstatus")).c_str(), 0)
  {
   return;
  }

  void change_dump(ostream& output)
  {
   return;
  }

  void reset_log()
  {
   return;
  }

  void suspend()
  {
   nu.suspend();
   savedstatus.suspend();
   return;
  }

  void behavior(nios32_parms::ac_stage_list stage = static_cast<nios32_parms::ac_stage_list>(0), int cycle = 0);
};

class nios32_fmt_F_K
{
  char* name;

 public:
  ac_sync_reg<unsigned long> k;

  nios32_fmt_F_K(char* n): name(n), k(std::string(std::string(n) + std::string("_k")).c_str(), 0)
  {
   return;
  }

  void change_dump(ostream& output)
  {
   return;
  }

  void reset_log()
  {
   return;
  }

  void suspend()
  {
   k.suspend();
   return;
  }

  void behavior(nios32_parms::ac_stage_list stage = static_cast<nios32_parms::ac_stage_list>(0), int cycle = 0);
};

#endif // _NIOS32_FMT_REGS_H_
